/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  EMAC Header file
 *
 */
#ifndef _DM388_EMAC_H_
#define _DM388_EMAC_H_

#ifdef __cplusplus
 extern "C" {
#endif

#include "DM8127_EVM.h"
#include <stdio.h>
#include "Ethernet_IO.h"

/* ------------------------------------------------------------------------ *
 *  EMAC Modes                                                              *
 * ------------------------------------------------------------------------ */
#define MII_MODE                1000
#define RMII_MODE               2000

/* ------------------------------------------------------------------------ *
 *  EMAC Descriptor                                                         *
 * ------------------------------------------------------------------------ */
typedef struct _EMAC_Desc {
    struct _EMAC_Desc *pNext;   // Pointer to next descriptor
    UINT8* pBuffer;             // Pointer to data buffer
    UINT32 BufOffLen;           // Buffer Offset(MSW) and Length(LSW)
    UINT32 PktFlgLen;           // Packet Flags(MSW) and Length(LSW)
} EMAC_Desc;

extern void EMAC_isr
(
	void
);
/* ------------------------------------------------------------------------ *
 *  EMAC Controller                                                         *
 * ------------------------------------------------------------------------ */
#define EMAC_BASE               	0x4A100000
#define EMAC_TXIDVER_BASE			EMAC_BASE + 0x100
#define EMAC_RXIDVER_BASE			EMAC_BASE + 0x110
#define EMAC_STATS_BASE				EMAC_BASE + 0x400
#define EMAC_ALE_BASE				EMAC_BASE + 0x600
#define EMAC_SWITCH_BASE			EMAC_BASE + 0x900


#define EMAC0_SLIVER_CTRL        *( volatile UINT32* )( EMAC_BASE + 0x704 ) // Per EMAC
#define EMAC1_SLIVER_CTRL        *( volatile UINT32* )( EMAC_BASE + 0x744 ) // Per EMAC

#define EMAC_RESET1		*( volatile UINT32* )( EMAC_BASE + 0x008 )
#define EMAC_RESET2		*( volatile UINT32* )( EMAC_BASE + 0x70C )
#define EMAC_RESET3		*( volatile UINT32* )( EMAC_BASE + 0x74C )

#define EMAC_STAT_PORT_EN		*( volatile UINT32* )( EMAC_BASE + 0x00C )
#define EMAC_P0_FLOW_THRESH		*( volatile UINT32* )( EMAC_BASE + 0x01C )
#define EMAC0_MACSRCADDRLO       *( volatile UINT32* )( EMAC_BASE + 0x02C )
#define EMAC0_MACSRCADDRHI       *( volatile UINT32* )( EMAC_BASE + 0x030 )
#define EMAC1_MACSRCADDRLO       *( volatile UINT32* )( EMAC_BASE + 0x04C )
#define EMAC1_MACSRCADDRHI       *( volatile UINT32* )( EMAC_BASE + 0x050 )
#define EMAC_P2_MAX_BLKS        *( volatile UINT32* )( EMAC_BASE + 0x054 )
#define EMAC_P2_TX_PRI_MAP		*( volatile UINT32* )( EMAC_BASE + 0x064 )
#define EMAC0_MACCONTROL         *( volatile UINT32* )( EMAC_BASE + 0x084 ) // Per EMAC
#define EMAC0_MACSTATUS          *( volatile UINT32* )( EMAC_BASE + 0x088 ) // Per EMAC
#define EMAC1_MACCONTROL         *( volatile UINT32* )( EMAC_BASE + 0x0C4 ) // Per EMAC
#define EMAC1_MACSTATUS          *( volatile UINT32* )( EMAC_BASE + 0x0C8 ) // Per EMAC
//#define EMAC_MACINVECTOR        *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0B0 )

#define EMAC_TXIDVER          	*( volatile UINT32* )( EMAC_TXIDVER_BASE )
#define EMAC_TXCONTROL          *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x004 )
#define EMAC_TXTEARDOWN         *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x008 )
#define EMAC_RXIDVER            *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x010 )
#define EMAC_RXCONTROL          *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x014 )
#define EMAC_RXTEARDOWN         *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x018 )
#define EMAC_SOFTRESET          *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x01C )
#define EMAC_DMACONTROL         *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x024 )
#define EMAC_RXBUFFEROFFSET     *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x028 )
#define EMAC_EMCONTROL          *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x02C )
#define EMAC_TXINTSTATRAW       *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x080 )
#define EMAC_TXINTSTATMASKED    *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x084 )
#define EMAC_TXINTMASKSET       *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x088 )
#define EMAC_TXINTMASKCLEAR     *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x08c )
//#define EMAC_MACINVECTOR        *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x090 )
#define EMAC_MACEOIVECTOR       *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x094 )
#define EMAC_RXINTSTATRAW       *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0A0 )
#define EMAC_RXINTSTATMASKED    *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0A4 )
#define EMAC_RXINTMASKSET       *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0A8 )
#define EMAC_RXINTMASKCLEAR     *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0Ac )
#define EMAC_MACINTSTATRAW      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0B0 )
#define EMAC_MACINTSTATMASKED   *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0B4 )
#define EMAC_MACINTMASKSET      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0B8 )
#define EMAC_MACINTMASKCLEAR    *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0Bc )

#if 0
#define EMAC_RXMBPENABLE        *( volatile UINT32* )( EMAC_BASE + 0x100 )
#define EMAC_RXUNICASTSET       *( volatile UINT32* )( EMAC_BASE + 0x104 )
#define EMAC_RXUNICASTCLEAR     *( volatile UINT32* )( EMAC_BASE + 0x108 )
#define EMAC_RXMAXLEN           *( volatile UINT32* )( EMAC_BASE + 0x10c )
#define EMAC_RXBUFFEROFFSET     *( volatile UINT32* )( EMAC_BASE + 0x110 )
#define EMAC_RXFILTERLOWTHRESH  *( volatile UINT32* )( EMAC_BASE + 0x114 )
#define EMAC_RX0FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x120 )
#define EMAC_RX1FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x124 )
#define EMAC_RX2FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x128 )
#define EMAC_RX3FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x12c )
#define EMAC_RX4FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x130 )
#define EMAC_RX5FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x134 )
#define EMAC_RX6FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x138 )
#define EMAC_RX7FLOWTHRESH      *( volatile UINT32* )( EMAC_BASE + 0x13c )
#endif

#define EMAC_RX0FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0E0 )
#define EMAC_RX1FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0E4 )
#define EMAC_RX2FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0E8 )
#define EMAC_RX3FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0Ec )
#define EMAC_RX4FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0F0 )
#define EMAC_RX5FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0F4 )
#define EMAC_RX6FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0F8 )
#define EMAC_RX7FREEBUFFER      *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x0Fc )
#define EMAC_TX0HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x100 )
#define EMAC_TX1HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x104 )
#define EMAC_TX2HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x108 )
#define EMAC_TX3HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x10c )
#define EMAC_TX4HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x110 )
#define EMAC_TX5HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x114 )
#define EMAC_TX6HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x118 )
#define EMAC_TX7HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x11c )
#define EMAC_RX0HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x120 )
#define EMAC_RX1HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x124 )
#define EMAC_RX2HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x128 )
#define EMAC_RX3HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x12c )
#define EMAC_RX4HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x130 )
#define EMAC_RX5HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x134 )
#define EMAC_RX6HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x138 )
#define EMAC_RX7HDP             *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x13c )
#define EMAC_TX0CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x140 )
#define EMAC_TX1CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x144 )
#define EMAC_TX2CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x148 )
#define EMAC_TX3CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x14c )
#define EMAC_TX4CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x150 )
#define EMAC_TX5CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x154 )
#define EMAC_TX6CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x158 )
#define EMAC_TX7CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x15c )
#define EMAC_RX0CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x160 )
#define EMAC_RX1CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x164 )
#define EMAC_RX2CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x168 )
#define EMAC_RX3CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x16c )
#define EMAC_RX4CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x170 )
#define EMAC_RX5CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x174 )
#define EMAC_RX6CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x178 )
#define EMAC_RX7CP              *( volatile UINT32* )( EMAC_TXIDVER_BASE + 0x17c )

#define EMAC_RXGOODFRAMES       *( volatile UINT32* )( EMAC_STATS_BASE + 0x000 )
#define EMAC_RXBCASTFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x004 )
#define EMAC_RXMCASTFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x008 )
#define EMAC_RXPAUSEFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x00c )
#define EMAC_RXCRCERRORS        *( volatile UINT32* )( EMAC_STATS_BASE + 0x010 )
#define EMAC_RXALIGNCODEERRORS  *( volatile UINT32* )( EMAC_STATS_BASE + 0x014 )
#define EMAC_RXOVERSIZED        *( volatile UINT32* )( EMAC_STATS_BASE + 0x018 )
#define EMAC_RXJABBER           *( volatile UINT32* )( EMAC_STATS_BASE + 0x01c )
#define EMAC_RXUNDERSIZED       *( volatile UINT32* )( EMAC_STATS_BASE + 0x020 )
#define EMAC_RXFRAGMENTS        *( volatile UINT32* )( EMAC_STATS_BASE + 0x024 )
#define EMAC_RXFILTERED         *( volatile UINT32* )( EMAC_STATS_BASE + 0x028 )
#define EMAC_RXQOSFILTERED      *( volatile UINT32* )( EMAC_STATS_BASE + 0x02c )
#define EMAC_RXOCTETS           *( volatile UINT32* )( EMAC_STATS_BASE + 0x030 )
#define EMAC_TXGOODFRAMES       *( volatile UINT32* )( EMAC_STATS_BASE + 0x034 )
#define EMAC_TXBCASTFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x038 )
#define EMAC_TXMCASTFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x03c )
#define EMAC_TXPAUSEFRAMES      *( volatile UINT32* )( EMAC_STATS_BASE + 0x040 )
#define EMAC_TXDEFERRED         *( volatile UINT32* )( EMAC_STATS_BASE + 0x044 )
#define EMAC_TXCOLLISION        *( volatile UINT32* )( EMAC_STATS_BASE + 0x048 )
#define EMAC_TXSINGLECOLL       *( volatile UINT32* )( EMAC_STATS_BASE + 0x04c )
#define EMAC_TXMULTICOLL        *( volatile UINT32* )( EMAC_STATS_BASE + 0x050 )
#define EMAC_TXEXCESSIVECOLL    *( volatile UINT32* )( EMAC_STATS_BASE + 0x054 )
#define EMAC_TXLATECOLL         *( volatile UINT32* )( EMAC_STATS_BASE + 0x058 )
#define EMAC_TXUNDERRUN         *( volatile UINT32* )( EMAC_STATS_BASE + 0x05c )
#define EMAC_TXCARRIERSENSE     *( volatile UINT32* )( EMAC_STATS_BASE + 0x060 )
#define EMAC_TXOCTETS           *( volatile UINT32* )( EMAC_STATS_BASE + 0x064 )
#define EMAC_FRAME64            *( volatile UINT32* )( EMAC_STATS_BASE + 0x068 )
#define EMAC_FRAME65T127        *( volatile UINT32* )( EMAC_STATS_BASE + 0x06c )
#define EMAC_FRAME128T255       *( volatile UINT32* )( EMAC_STATS_BASE + 0x070 )
#define EMAC_FRAME256T511       *( volatile UINT32* )( EMAC_STATS_BASE + 0x074 )
#define EMAC_FRAME512T1023      *( volatile UINT32* )( EMAC_STATS_BASE + 0x078 )
#define EMAC_FRAME1024TUP       *( volatile UINT32* )( EMAC_STATS_BASE + 0x07c )
#define EMAC_NETOCTETS          *( volatile UINT32* )( EMAC_STATS_BASE + 0x080 )
#define EMAC_RXSOFOVERRUNS      *( volatile UINT32* )( EMAC_STATS_BASE + 0x084 )
#define EMAC_RXMOFOVERRUNS      *( volatile UINT32* )( EMAC_STATS_BASE + 0x088 )
#define EMAC_RXDMAOVERRUNS      *( volatile UINT32* )( EMAC_STATS_BASE + 0x08c )

#define EMAC_ALE_IDVER			*( volatile UINT32* )( EMAC_ALE_BASE )
#define EMAC_ALE_CONTROL		*( volatile UINT32* )( EMAC_ALE_BASE + 0x08 )
#define EMAC_ALE_PRESCALE		*( volatile UINT32* )( EMAC_ALE_BASE + 0x10 )
#define EMAC_ALE_UVLAN			*( volatile UINT32* )( EMAC_ALE_BASE + 0x18 )
#define EMAC_ALE_TBLCTL			*( volatile UINT32* )( EMAC_ALE_BASE + 0x20 )
#define EMAC_ALE_TBLWRD2		*( volatile UINT32* )( EMAC_ALE_BASE + 0x34 )
#define EMAC_ALE_TBLWRD1		*( volatile UINT32* )( EMAC_ALE_BASE + 0x38 )
#define EMAC_ALE_TBLWRD0		*( volatile UINT32* )( EMAC_ALE_BASE + 0x3C )
#define EMAC_ALE_PORTCTL0		*( volatile UINT32* )( EMAC_ALE_BASE + 0x40 )
#define EMAC_ALE_PORTCTL1		*( volatile UINT32* )( EMAC_ALE_BASE + 0x44 )
#define EMAC_ALE_PORTCTL2		*( volatile UINT32* )( EMAC_ALE_BASE + 0x48 )

/* EMAC Wrapper */
#define EMAC_EWSOFTRESET        *( volatile UINT32* )( EMAC_SWITCH_BASE + 0x004 )
#define EMAC_EWEMCONTROL        *( volatile UINT32* )( EMAC_SWITCH_BASE + 0x008 )
#define EMAC_EWRXEN             *( volatile UINT32* )( EMAC_SWITCH_BASE + 0x014 )
#define EMAC_EWTXEN             *( volatile UINT32* )( EMAC_SWITCH_BASE + 0x018 )

/* EMAC RAM */
#define EMAC_RAM_BASE           0x4A102000
#define EMAC_RAM_LEN            0x00002000

/* Packet Flags */
#define EMAC_DSC_FLAG_SOP               0x80000000
#define EMAC_DSC_FLAG_EOP               0x40000000
#define EMAC_DSC_FLAG_OWNER             0x20000000
#define EMAC_DSC_FLAG_EOQ               0x10000000
#define EMAC_DSC_FLAG_TDOWNCMPLT        0x08000000
#define EMAC_DSC_FLAG_PASSCRC           0x04000000

/* The following flags are RX only */
#define EMAC_DSC_FLAG_JABBER            0x02000000
#define EMAC_DSC_FLAG_OVERSIZE          0x01000000
#define EMAC_DSC_FLAG_FRAGMENT          0x00800000
#define EMAC_DSC_FLAG_UNDERSIZED        0x00400000
#define EMAC_DSC_FLAG_CONTROL           0x00200000
#define EMAC_DSC_FLAG_OVERRUN           0x00100000
#define EMAC_DSC_FLAG_CODEERROR         0x00080000
#define EMAC_DSC_FLAG_ALIGNERROR        0x00040000
#define EMAC_DSC_FLAG_CRCERROR          0x00020000
#define EMAC_DSC_FLAG_NOMATCH           0x00010000
#define EMAC_TO_PORT_ENABLE				(1 << 20)
#define EMAC_TO_PORT					(1 << 16)

/* Interrupts */
#define EMAC_MACINVECTOR_USERINT        0x01000000
#define EMAC_MACINVECTOR_LINKINT        0x02000000
//#define EMAC_MACINVECTOR_HOSTPEND       0x04000000
//#define EMAC_MACINVECTOR_STATPEND       0x08000000
#define EMAC_MACINVECTOR_HOSTPEND       0x00000002
#define EMAC_MACINVECTOR_STATPEND       0x00000001
#define EMAC_MACINVECTOR_RXPEND         0x000000FF
#define EMAC_MACINVECTOR_TXPEND         0x001F0000
#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

UINT16 gmii_phy_getReg
(
	SINT16 phynum,
	SINT16 regnum
);

/* ------------------------------------------------------------------------ *
 *  gmii_phy_setReg( phynum, regnum, data )                                 *
 * ------------------------------------------------------------------------ */
void gmii_phy_setReg
(
	SINT16 phynum,
	SINT16 regnum,
	UINT16 data
);

/* ------------------------------------------------------------------------ *
 *  gmii_phy_dumpRegs( )                                                    *
 * ------------------------------------------------------------------------ */
void gmii_phy_dumpRegs
(
	void
);
/* ------------------------------------------------------------------------ *
 *  emac_mii_init( phynum )                                                       *
 * ------------------------------------------------------------------------ */
SINT16 emac_mii_init
(
	SINT16 phynum
);

/* ------------------------------------------------------------------------ *
 *  verify_packet                                                           *
 * ------------------------------------------------------------------------ */
static SINT16 verify_packet
(
	EMAC_Desc* pDesc,
	UINT32 size,
	UINT32 flagCRC
);
/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  emac_gmii_test( )                                                       *
 *                                                                          *
 * ------------------------------------------------------------------------ */
STATUS emac_gmii_test
(
	void *testargs
);
/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  test_gmii_packet( )                                                     *
 *      EMAC tests to send data to external loopback cable.                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
SINT16 test_gmii_packet
(
	void
);

/* ------------------------------------------------------------------------ *
 *  emac_gmii_init( phynum )                                                       *
 * ------------------------------------------------------------------------ */
SINT16 emac_gmii_init
(
	SINT16 phynum
);
 /****
  *\brief: Phy detection function.
  *
  *\descr: This function detects the PHY chip on the connected board
  *        it prints the address where Phy found.
  *
  *\param: phyaddr  [IN] PHY base address
  *
  *\return: Dummy variable
  */
 UINT16 gmii_phy_detect
 (
 	UINT16 *phyaddr
 );

#endif  /* End of _DM388_EMAC_H_ */
